// VERSION :Scilab:6.0.1
// OS : WINDOWS 10
// CAPTION:DETERMINATION OF EVEN & ODD PART OF CT SIGNAL
clc ;
clear all;
close ;
//Input CT Signal
t=-2:1:2;
x=[1,1,0,1,0];
subplot (2,3,1);
plot(t,x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("Input CT Signal x(t)");
c=3;
for j=1:length(t)
    i=n(j);
    xe(j)=(1/2)*(x(c+i)+x(c-i));
    xo(j)=(1/2)*(x(c+i)-x(c-i));
end
xe=[xe(c-2),xe(c-1),xe(c+0),xe(c+1),xe(c+2)];
xo=[xo(c-2),xo(c-1),xo(c+0),xo(c+1),xo(c+2)];
subplot (2,3,2);
plot(t,xe);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("Xe(t)=1/2[x(t)+x(-t)]");
subplot (2,3,3);
plot(t,-xo);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("Xo(t)=1/2[x(t)-x(-t)]");

